using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.Common;
using System.Windows.Forms;
using CANNEDCOMMENT = gov.va.med.vbecs.Common.VbecsTables.CannedComment;
using CANNEDCOMMENTCATEGORY = gov.va.med.vbecs.Common.VbecsTables.CannedCommentCategory;

namespace gov.va.med.vbecs.GUI
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///UI Form to allow enhanced supervisors to Maintain Canned Comments 
		///</summary>

		#endregion


	public class FrmMaintainComments : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Variables

		/// <summary>
		/// Canned comment object being defined by user
		/// </summary>
		private BOL.CannedComment _cannedComment;

		/// <summary>
		/// Data table containing all canned comments for the division
		/// </summary>
		private DataTable _cannedComments;

		/// <summary>
		/// Data row array containing canned comments for the category selected
		/// </summary>
		private DataRow[] _categoryCannedComments;

		private DataRow[] _inactiveCannedComments;

		/// <summary>
		/// Stores the highest sort index on display in the list view 
		/// </summary>
		private short _lastSortIndex;

		/// <summary>
		/// Data table containing canned comment categories
		/// </summary>
		private DataTable _categories;
		
		private bool _refreshing = false;
		private bool _removeItem;

		#endregion

		#region Form Controls
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.Panel pnlComments;
		private System.Windows.Forms.GroupBox grpComment;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.GroupBox grpComments;
		private System.Windows.Forms.Panel pnlUpDown;
		private System.Windows.Forms.Button btnDown;
		private System.Windows.Forms.Button btnUp;
		private System.Windows.Forms.ListView lvComments;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSave;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.Label lblContext;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbContext;
		private System.Windows.Forms.TabControl tabComments;
		private System.Windows.Forms.CheckBox cbShowInactive;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.ColumnHeader colActive;
		private System.Windows.Forms.ColumnHeader colComment;
		private System.Windows.Forms.ColumnHeader colInactivation;
		private System.Windows.Forms.ColumnHeader colCreation;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// FrmMaintainComments constructor.
		/// Checks security level.
		/// Sets broken rules event handlers.
		/// Loads all canned comments for the user's division.
		/// </summary>
		public FrmMaintainComments()
		{
		    _removeItem = false;
			this.LockController.LockFunction = Common.LockFunctions.UC031MaintainCannedComments;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
			//
			try
			{
				this._cannedComment = new BOL.CannedComment(System.Guid.NewGuid());
				this._cannedComment.LastUpdateUser = ThisUser.UserNTLoginID;
				//setting the event to fire the setdirtyflag function
				this._cannedComment.IsDirtyChanged += new System.EventHandler(CheckValid);
				//this._cannedComment.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
				this._cannedComment.Valid += new System.EventHandler(CheckValid);
				this._cannedComment.Invalid += new System.EventHandler(CheckValid);
				this._cannedComment.SetInitialBrokenRules(this.Name);
				//
				_cannedComments = BOL.CannedComment.GetCannedComments();//(false);
				//_cannedComments.RowChanged += new System.Data.DataRowChangeEventHandler(EnableOKButton);
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.GeneralError(err.Message));
				this.Close();
			}
			//
			//this.tabComments.SelectedIndex = 0;
			this._categories = BOL.CannedComment.GetCannedCommentCategories();
			//
			this.SetBindings();
			//
			this.RefreshListView();
			this.Clear();
			
			//Initial dirty of form.
			this.IsDirty=false;
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmMaintainComments));
            this.txtComment = new System.Windows.Forms.TextBox();
            this.btnDown = new System.Windows.Forms.Button();
            this.imageList1 = new System.Windows.Forms.ImageList(this.components);
            this.btnUp = new System.Windows.Forms.Button();
            this.lvComments = new System.Windows.Forms.ListView();
            this.colActive = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colComment = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colCreation = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colInactivation = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.btnClear = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.pnlComments = new System.Windows.Forms.Panel();
            this.grpComment = new System.Windows.Forms.GroupBox();
            this.btnSave = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.lblComment = new System.Windows.Forms.Label();
            this.grpComments = new System.Windows.Forms.GroupBox();
            this.cbShowInactive = new System.Windows.Forms.CheckBox();
            this.pnlUpDown = new System.Windows.Forms.Panel();
            this.lblContext = new System.Windows.Forms.Label();
            this.cmbContext = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.tabComments = new System.Windows.Forms.TabControl();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.pnlComments.SuspendLayout();
            this.grpComment.SuspendLayout();
            this.grpComments.SuspendLayout();
            this.pnlUpDown.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(544, 30);
            this.vbecsLogo1.TabIndex = 6;
            this.vbecsLogo1.Title = "Maintain Comments";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 8;
            // 
            // txtComment
            // 
            this.txtComment.AccessibleDescription = "Comment";
            this.txtComment.AccessibleName = "Comment";
            this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtComment.Location = new System.Drawing.Point(92, 12);
            this.txtComment.MaxLength = 80;
            this.txtComment.Name = "txtComment";
            this.txtComment.Size = new System.Drawing.Size(348, 20);
            this.txtComment.TabIndex = 1;
            this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
            // 
            // btnDown
            // 
            this.btnDown.ImageIndex = 1;
            this.btnDown.ImageList = this.imageList1;
            this.btnDown.Location = new System.Drawing.Point(0, 36);
            this.btnDown.Name = "btnDown";
            this.btnDown.Size = new System.Drawing.Size(23, 23);
            this.btnDown.TabIndex = 1;
            this.btnDown.Click += new System.EventHandler(this.btnDown_Click);
            // 
            // imageList1
            // 
            this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
            this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
            this.imageList1.Images.SetKeyName(0, "");
            this.imageList1.Images.SetKeyName(1, "");
            // 
            // btnUp
            // 
            this.btnUp.ImageIndex = 0;
            this.btnUp.ImageList = this.imageList1;
            this.btnUp.Location = new System.Drawing.Point(0, 0);
            this.btnUp.Name = "btnUp";
            this.btnUp.Size = new System.Drawing.Size(23, 23);
            this.btnUp.TabIndex = 0;
            this.btnUp.Click += new System.EventHandler(this.btnUp_Click);
            // 
            // lvComments
            // 
            this.lvComments.AccessibleDescription = "Comments";
            this.lvComments.AccessibleName = "Comments";
            this.lvComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvComments.CheckBoxes = true;
            this.lvComments.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colActive,
            this.colComment,
            this.colCreation,
            this.colInactivation});
            this.lvComments.FullRowSelect = true;
            this.lvComments.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lvComments.HideSelection = false;
            this.lvComments.Location = new System.Drawing.Point(8, 16);
            this.lvComments.MultiSelect = false;
            this.lvComments.Name = "lvComments";
            this.lvComments.Size = new System.Drawing.Size(408, 240);
            this.lvComments.TabIndex = 0;
            this.lvComments.UseCompatibleStateImageBehavior = false;
            this.lvComments.View = System.Windows.Forms.View.Details;
            this.lvComments.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvComments_ItemCheck);
            this.lvComments.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvComments_ItemChecked);
            this.lvComments.SelectedIndexChanged += new System.EventHandler(this.lvComments_Click);
            this.lvComments.Click += new System.EventHandler(this.lvComments_Click);
            this.lvComments.MouseUp += new System.Windows.Forms.MouseEventHandler(this.lvComments_MouseUp);
            // 
            // colActive
            // 
            this.colActive.Text = "Active";
            this.colActive.Width = 45;
            // 
            // colComment
            // 
            this.colComment.Text = "Comment";
            this.colComment.Width = 240;
            // 
            // colCreation
            // 
            this.colCreation.Text = "Creation Details";
            this.colCreation.Width = 110;
            // 
            // colInactivation
            // 
            this.colInactivation.Text = "Inactivation Details";
            this.colInactivation.Width = 110;
            // 
            // btnClear
            // 
            this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClear.Location = new System.Drawing.Point(364, 36);
            this.btnClear.Name = "btnClear";
            this.btnClear.Size = new System.Drawing.Size(75, 23);
            this.btnClear.TabIndex = 3;
            this.btnClear.Text = "C&lear";
            this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 408);
            this.grpImage.TabIndex = 7;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // pnlComments
            // 
            this.pnlComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlComments.Controls.Add(this.grpComment);
            this.pnlComments.Controls.Add(this.grpComments);
            this.pnlComments.Location = new System.Drawing.Point(64, 80);
            this.pnlComments.Name = "pnlComments";
            this.pnlComments.Size = new System.Drawing.Size(464, 356);
            this.pnlComments.TabIndex = 3;
            // 
            // grpComment
            // 
            this.grpComment.AccessibleDescription = "Comment";
            this.grpComment.AccessibleName = "Comment";
            this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComment.Controls.Add(this.btnClear);
            this.grpComment.Controls.Add(this.btnSave);
            this.grpComment.Controls.Add(this.txtComment);
            this.grpComment.Controls.Add(this.lblComment);
            this.grpComment.Location = new System.Drawing.Point(4, 3);
            this.grpComment.Name = "grpComment";
            this.grpComment.Size = new System.Drawing.Size(456, 68);
            this.grpComment.TabIndex = 0;
            this.grpComment.TabStop = false;
            // 
            // btnSave
            // 
            this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSave.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSave.Image = ((System.Drawing.Image)(resources.GetObject("btnSave.Image")));
            this.btnSave.Location = new System.Drawing.Point(284, 36);
            this.btnSave.Name = "btnSave";
            this.btnSave.Size = new System.Drawing.Size(75, 23);
            this.btnSave.TabIndex = 2;
            this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
            this.btnSave.MouseHover += new System.EventHandler(this.btnSave_MouseHover);
            // 
            // lblComment
            // 
            this.lblComment.Location = new System.Drawing.Point(8, 12);
            this.lblComment.Name = "lblComment";
            this.lblComment.Size = new System.Drawing.Size(80, 20);
            this.lblComment.TabIndex = 0;
            this.lblComment.Text = "Comment*";
            this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpComments
            // 
            this.grpComments.AccessibleDescription = "Comments";
            this.grpComments.AccessibleName = "Comments";
            this.grpComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComments.Controls.Add(this.cbShowInactive);
            this.grpComments.Controls.Add(this.pnlUpDown);
            this.grpComments.Controls.Add(this.lvComments);
            this.grpComments.Location = new System.Drawing.Point(4, 75);
            this.grpComments.Name = "grpComments";
            this.grpComments.Size = new System.Drawing.Size(456, 278);
            this.grpComments.TabIndex = 1;
            this.grpComments.TabStop = false;
            this.grpComments.Text = "Comments";
            // 
            // cbShowInactive
            // 
            this.cbShowInactive.AccessibleDescription = "Show Inactive Comments";
            this.cbShowInactive.AccessibleName = "Show Inactive Comments";
            this.cbShowInactive.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbShowInactive.Location = new System.Drawing.Point(8, 256);
            this.cbShowInactive.Name = "cbShowInactive";
            this.cbShowInactive.Size = new System.Drawing.Size(436, 16);
            this.cbShowInactive.TabIndex = 2;
            this.cbShowInactive.Text = "&Show Inactive Comments";
            this.cbShowInactive.CheckedChanged += new System.EventHandler(this.cbShowInactive_CheckedChanged);
            // 
            // pnlUpDown
            // 
            this.pnlUpDown.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlUpDown.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.pnlUpDown.Controls.Add(this.btnDown);
            this.pnlUpDown.Controls.Add(this.btnUp);
            this.pnlUpDown.Enabled = false;
            this.pnlUpDown.Location = new System.Drawing.Point(416, 16);
            this.pnlUpDown.Name = "pnlUpDown";
            this.pnlUpDown.Size = new System.Drawing.Size(28, 240);
            this.pnlUpDown.TabIndex = 1;
            // 
            // lblContext
            // 
            this.lblContext.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblContext.Location = new System.Drawing.Point(60, 36);
            this.lblContext.Name = "lblContext";
            this.lblContext.Size = new System.Drawing.Size(468, 20);
            this.lblContext.TabIndex = 0;
            this.lblContext.Text = "Select Comment Category Type*";
            this.lblContext.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cmbContext
            // 
            this.cmbContext.AccessibleDescription = "Select Comment Category Type";
            this.cmbContext.AccessibleName = "Select Comment Category Type";
            this.cmbContext.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbContext.Interval = 100;
            this.cmbContext.Location = new System.Drawing.Point(60, 52);
            this.cmbContext.MaxLength = 50;
            this.cmbContext.Name = "cmbContext";
            this.cmbContext.Size = new System.Drawing.Size(472, 22);
            this.cmbContext.TabIndex = 1;
            this.cmbContext.SelectedIndexChanged += new System.EventHandler(this.cmbContext_SelectedIndexChanged);
            // 
            // tabComments
            // 
            this.tabComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabComments.Location = new System.Drawing.Point(60, 76);
            this.tabComments.Name = "tabComments";
            this.tabComments.SelectedIndex = 0;
            this.tabComments.Size = new System.Drawing.Size(472, 364);
            this.tabComments.TabIndex = 2;
            this.tabComments.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.CausesValidation = false;
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(456, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 5;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(376, 448);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 4;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // FrmMaintainComments
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(544, 473);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.pnlComments);
            this.Controls.Add(this.tabComments);
            this.Controls.Add(this.cmbContext);
            this.Controls.Add(this.lblContext);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Canned_Comments.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(552, 308);
            this.Name = "FrmMaintainComments";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Maintain Comments";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmMaintainComments_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.FrmMaintainComments_Load);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.lblContext, 0);
            this.Controls.SetChildIndex(this.cmbContext, 0);
            this.Controls.SetChildIndex(this.tabComments, 0);
            this.Controls.SetChildIndex(this.pnlComments, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.pnlComments.ResumeLayout(false);
            this.grpComment.ResumeLayout(false);
            this.grpComment.PerformLayout();
            this.grpComments.ResumeLayout(false);
            this.pnlUpDown.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods

		private void SetBindings()
		{
			this.cmbContext.Items.Clear();
			//
			foreach(DataRow dr in this._categories.Rows)
			{
				this.cmbContext.Items.Add(dr[CANNEDCOMMENTCATEGORY.CannedCommentCategoryText].ToString());
			}
			this.cmbContext.SelectedIndex = -1;
		}


		/// <summary>
		/// Gets the LockingGuid for the current selected comment category, returns EMPTY on N/F
		/// </summary>
		private Guid CategoryLockingGuid
		{
			get
			{
				System.Guid lockingGuid = System.Guid.Empty;
				int rowIndex = this.cmbContext.SelectedIndex;

				if (rowIndex >= 0)
				{
					lockingGuid = (System.Guid)this._categories.Rows[rowIndex][CANNEDCOMMENTCATEGORY.LockingGuid];
				}
					
				return(lockingGuid);
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Private method to set properties of user controls
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Maintain Comments";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC031.FrmMaintainComments());
			//
			this.btnSave.Text = "&Add";
			this.btnSave.EnabledButton = false;
			//
			this.btnOK.Text = "&OK";

			this.SetToolTips();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Private method to clear the form for entry of a new canned comment
		/// </summary>
		private void Clear()
		{
			this.btnSave.Text = "&Add";
			//
			this.txtComment.Text = string.Empty;
			this._cannedComment.Comments = string.Empty;
			this._cannedComment.SortIndex = 0;
			this._cannedComment.RecordStatusCode = Common.RecordStatusCode.Active;
			this._cannedComment.IsNew = true;
			this._cannedComment.IsDirty = false;
			//
			//this.lvComments.SelectedItems.Clear();
			//
			//this.txtComment.Focus();
		}

		private void SetToolTips()
		{
			this.SetThisToolTip(this.cmbContext, Common.StrRes.Tooltips.UC031.CommentCategory());
			this.SetThisToolTip(this.txtComment, Common.StrRes.Tooltips.UC031.CommentText());
			this.SetThisToolTip(this.lvComments, Common.StrRes.Tooltips.UC031.CannedCommentList());
			this.SetThisToolTip(this.cbShowInactive, Common.StrRes.Tooltips.Common.ShowInactive("canned comments"));
			//Set the tooltips
			this.SetThisToolTip(btnDown, Common.StrRes.Tooltips.UC031.MoveCommentDown());
			this.SetThisToolTip(btnCancel, Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn());
			this.SetThisToolTip(btnClear, Common.StrRes.Tooltips.Common.ClearEntries());
			this.SetThisToolTip(btnUp, Common.StrRes.Tooltips.UC031.MoveCommentUp());
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Private method to prompt user to save changes to file
		/// </summary>
		private bool Save()
		{
			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("canned comment"));
			if (_saveResult == DialogResult.Yes)
			{
				try
				{
					if (BOL.CannedComment.Save(this._cannedComments,Common.UpdateFunction.UC031FrmMaintainComments))
					{
						return true;
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("canned comment"));
					}
				}
				catch(RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
			}
			//
			return false;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Private function to return the CannedCommentCategory enum based on the tab selected
		/// </summary>
		/// <returns>Canned Comment Category</returns>
		private string GetCategoryType()
		{
			if (this.cmbContext.SelectedIndex>-1)
			{
				return this._categories.Rows[this.cmbContext.SelectedIndex][CANNEDCOMMENTCATEGORY.CannedCommentCategoryCode].ToString();
			}
			return string.Empty;

			//this.cmbContext.SelectedValue.ToString();
//			Common.CannedCommentCategory CCC;
//			//
//			switch(this.tabComments.SelectedIndex)
//			{
//				case (0):
//				{
//					CCC = Common.CannedCommentCategory.PatientTesting;
//					break;
//				}
//				case (1):
//				{
//					CCC = Common.CannedCommentCategory.SpecimenProcessing;
//					break;
//				}
//				case (2):
//				{
//					CCC = Common.CannedCommentCategory.TransfusionProcessing;
//					break;
//				}
//				case (3):
//				{
//					CCC = Common.CannedCommentCategory.UnitIssue;
//					break;
//				}
//				case (4):
//				{
//					CCC = Common.CannedCommentCategory.UnitCrossmatch;
//					break;
//				}
//				case (5):
//				{
//					CCC = Common.CannedCommentCategory.UnitTesting;
//					break;
//				}
//				case (6):
//				{
//					CCC = Common.CannedCommentCategory.UnitReturn;
//					break;
//				}
//				default:
//				{
//					CCC = Common.CannedCommentCategory.Unknown;
//					break;
//				}
//			}
//			
//			return CCC;
			//
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Private method to refresh items in the list view based on the tab selected and sort order
		/// </summary>
		private void RefreshListView()
		{
			string cat = this.GetCategoryType();
			this.lvComments.Items.Clear();
			if (cat != string.Empty)
			{
				this.grpComment.Enabled = true;
				this._categoryCannedComments = GetCannedCommentsForCategory(cat);
				this._inactiveCannedComments = GetInactiveCannedCommentsForCategory(cat);
				this.LoadCannedComments();
			}
			else
			{
				this.grpComment.Enabled = false;
			}
		}


		/// <summary>
		/// Private function to filter INACTIVE comments of the specified category from the data table of comments
		/// and return them in a data row array
		/// </summary>
		/// <param name="category"></param>
		/// <returns></returns>
		private DataRow[] GetInactiveCannedCommentsForCategory(string category)
		{
			string selStr = CANNEDCOMMENT.CannedCommentCategoryCode + " = '" + category + "' AND " + CANNEDCOMMENT.RecordStatusCode + " = 'X'";
			string sortStr = CANNEDCOMMENT.SortColumn + " ASC";
			return this._cannedComments.Select(selStr,sortStr);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Private function to filter ACTIVE comments of the specified category from the data table of comments
		/// and return them in a data row array
		/// </summary>
		/// <param name="category">Canned Comment Category</param>
		/// <returns>Data row array containing canned comments</returns>
		private DataRow[] GetCannedCommentsForCategory(string category)//Common.CannedCommentCategory category)
		{
			// 8/4/2003 Added filter to only retrieve active canned comments.  See comments in spGetCannedComments for more information
			string selStr = CANNEDCOMMENT.CannedCommentCategoryCode + " = '" + category + "' AND " + CANNEDCOMMENT.RecordStatusCode + " = 'A'";
			string sortStr = CANNEDCOMMENT.SortColumn + " ASC";
			return this._cannedComments.Select(selStr,sortStr);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Private method to populate list view with all comments of the current category type.
		/// Also sets the highest sort amongst the displayed list.
		/// </summary>
		private void LoadCannedComments()
		{
			this._lastSortIndex = 0;
			_refreshing = true;
			//
			foreach(DataRow dr in this._categoryCannedComments)
			{
				BOL.CannedComment comment = new BOL.CannedComment(dr);
				ListViewItem lviComment = new ListViewItem();
				//
				lviComment.Tag = dr;
				//
				lviComment.Checked = true;
				lviComment.SubItems.Add(comment.Comments);
				lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateString(dr["CreationDate"]) + " by " + new BOL.VbecsUser(dr["CreationUser"].ToString()).UserName);
				lviComment.SubItems.Add(string.Empty);
				//
				this.lvComments.Items.Add(lviComment);
				//
				if ((short)dr[CANNEDCOMMENT.SortColumn]>this._lastSortIndex)
				{
					this._lastSortIndex = (short)dr[CANNEDCOMMENT.SortColumn];
				}
			}
			// Display inactive Comments now
			if (this.cbShowInactive.Checked)
			{
				foreach (DataRow dr in this._inactiveCannedComments)
				{
					BOL.CannedComment comment = new BOL.CannedComment(dr);
					ListViewItem lviComment = new ListViewItem();
					lviComment.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
					lviComment.Tag = dr;
					//
					lviComment.Checked = false;
					lviComment.SubItems.Add(comment.Comments);
					lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateString(dr["CreationDate"]) + " by " + new BOL.VbecsUser(dr["CreationUser"].ToString()).UserName);
					lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateString(dr["InactivationDate"]) + " by " + new BOL.VbecsUser(dr["InactivationUser"].ToString()).UserName);
					//
					this.lvComments.Items.Add(lviComment);
					//
					if ((short)dr[CANNEDCOMMENT.SortColumn]>this._lastSortIndex)
					{
						this._lastSortIndex = (short)dr[CANNEDCOMMENT.SortColumn];
					}

				}
			}
			_refreshing = false;
			//
			if (this.lvComments.Items.Count==0)
			{
				this.pnlUpDown.Enabled = false;
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvComments);
			//this.lvComments.Refresh();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Private method to add details from a canned comment object to the data table.
		/// </summary>
		/// <param name="comment">Canned comment object</param>
		private void AddCommentToDataTable(BOL.CannedComment comment)
		{
			comment.CannedCommentGuid = Guid.NewGuid();
			comment.SortIndex = (short)(this._lastSortIndex+1);
			comment.LastUpdateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			comment.LastUpdateUser = ThisUser.UserNTLoginID;
			comment.RecordStatusCode = Common.RecordStatusCode.Active;
			DataRow dr = comment.LoadDataRowFromThis(_cannedComments.NewRow());
			dr["CreationDate"] = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			dr["CreationUser"] = ThisUser.UserNTLoginID;
			this._cannedComments.Rows.Add(dr);
			//
		}

		#endregion

		#region Events

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Broken rules and IsDirty change event handler. Enables save button if data is valid and has changed.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			if (this._cannedComment.IsValid && this._cannedComment.IsDirty)
			{
				btnSave.EnabledButton = true;
			}
			else
			{
				btnSave.EnabledButton = false;
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Enables OK button to allow saving of changed information.
		/// </summary>
		private void EnableOKButton()//object sender, System.Data.DataRowChangeEventArgs e)
		{
			btnOK.EnabledButton = true;
			//If OK button is enabled, then a change has occured on the form
			//and thus it is dirty.
			this.IsDirty=true;
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmMaintainComments_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnSave.EnabledButton == false && this.cmbContext.SelectedIndex != -1)
			{
				this.btnSave_MouseHover(this, EventArgs.Empty);
				textToSpeak = this.btnSave.GetToolTip();
			}
			else if (this.btnOK.EnabledButton == false)
			{
				this.btnOK_MouseHover(this, EventArgs.Empty);
				textToSpeak = this.btnOK.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}

		#endregion

		#region Control Events
		/// <summary>
		/// User requests to view comments for a different context. Refresh the list.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbContext_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.Clear();
			this._cannedComment.CannedCommentType = GetCategoryType();
			RefreshListView();
		}


		/// <summary>
		/// User requests to view inactive comments. Refresh the list.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbShowInactive_CheckedChanged(object sender, System.EventArgs e)
		{
			this.RefreshListView();
			//
			this.txtComment.Focus();
		}

		
		/// <summary>
		/// If the user checks or unchecks an item, the list must be redisplayed, and the
		/// orginal selected item must be re-selected, even if it has changed position due
		/// to being activated/inactivated.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvComments_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (this.lvComments.SelectedItems.Count>0)
			{
				DataRow drSelected = (DataRow)this.lvComments.SelectedItems[0].Tag;
				short selected = (short)drSelected[CANNEDCOMMENT.SortColumn];
				RefreshListView();

				foreach (ListViewItem lvi in this.lvComments.Items)
				{
					DataRow dr = (DataRow)lvi.Tag;
					if ((short)dr[CANNEDCOMMENT.SortColumn] == selected)
					{
						lvi.Selected = true;
						break;
					}
				}
			}
			else
			{
				this.pnlUpDown.Enabled = false;
			}
		}

		
		

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Save button click event hanlder.
		/// Adds new comment to or updates existing comment in data table, then refreshes list of comments.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			if (!this.SetLocks(this.CategoryLockingGuid))
			{
				return;
			}

			if (this._cannedComment.IsNew)
			{
				this.AddCommentToDataTable(_cannedComment);
				EnableOKButton();
			}
			//
			this.RefreshListView();
			//
			this.Clear();
			//
			this.txtComment.Focus();
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Comment text box change event handler. 
		/// Sets Comments property of canned comment object to text entered
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				this._cannedComment.Comments = this.txtComment.Text;
				this.errError.SetVbecsError(this.txtComment, string.Empty); // **** 508 Compliance ***
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtComment, err.Message); // **** 508 Compliance ***
				return;
			}
			catch (Exception err)
			{
				this.errError.SetVbecsError(this.txtComment, err.Message); // **** 508 Compliance ***
				return;
			}
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Comments list view check box change event handler. Updates data row with new record status value.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Item check event args</param>
		private void lvComments_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			if (!_refreshing)
			{
				DataRow dr = (DataRow)this.lvComments.Items[e.Index].Tag;

				if (!this.SetLocks(this.CategoryLockingGuid))
				{
					e.NewValue = e.CurrentValue;
					return;
				}

				if (e.NewValue == CheckState.Checked)
				{
					//Ensure that it is actually changing - to maintain GetChanges() integrity
					if (System.Convert.ToChar(dr[Common.VbecsTables.RecordStatus.RecordStatusCode].ToString()) != Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active))
					{
						this.lvComments.Items[e.Index].Selected = true;
						dr[Common.VbecsTables.RecordStatus.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
						dr[CANNEDCOMMENT.LastUpdateUser] = ThisUser.UserNTLoginID;
						dr[CANNEDCOMMENT.LastUpdateDate] = currentDate;
						EnableOKButton();
					}
				}
				else
				{
					//Ensure that it is actually changing - to maintain GetChanges() integrity
					if (System.Convert.ToChar(dr[Common.VbecsTables.RecordStatus.RecordStatusCode].ToString()) != Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive))
					{
						//Delete if its new
						if (dr.RowState == DataRowState.Added)
						{
						    _removeItem = true;
							this._cannedComments.Rows.Remove(dr);
						}
						else
						{
							this.lvComments.Items[e.Index].Selected = true;
							dr[Common.VbecsTables.RecordStatus.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
							dr[CANNEDCOMMENT.LastUpdateUser] = ThisUser.UserNTLoginID;
							dr[CANNEDCOMMENT.LastUpdateDate] = currentDate;
							dr[Common.VbecsTables.ExceptionPatientTestInactivated.InactivationDate] = currentDate;
							dr["InactivationUser"] = ThisUser.UserNTLoginID;
						}
						EnableOKButton();
					}
				}
			}
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Cancel button click event handler. Closes form.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// OK button click event handler. Calls Save() method.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (this.Save())
			{
				this.IsDirty = false;
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Clear button click event handler. Calls Clear() method.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this.Clear();
			this.txtComment.Focus();
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Comments list view click event handler.
		/// Enables up/down buttons.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void lvComments_Click(object sender, System.EventArgs e)
		{
			if ((this.lvComments.SelectedItems.Count>0) && (this.lvComments.SelectedItems[0].Checked))
			{
				this.pnlUpDown.Enabled = true;
			}
			else
			{
				this.pnlUpDown.Enabled = false;
			}
			this.SpeakListViewWithCheckBox(lvComments);
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Form load event handler.
		/// Accepts data table changes, to maintain GetChanges() integrity.
		/// Disables OK button.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void FrmMaintainComments_Load(object sender, System.EventArgs e)
		{
			this._cannedComments.AcceptChanges();
			this.btnOK.EnabledButton = false;
			//Setting the initial dirty of the form.
			this.IsDirty=false;
			
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Down button click event handler. 
		/// Increments sort index of selected item and decrements sort index of item below.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnDown_Click(object sender, System.EventArgs e)
		{
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			if ((this.lvComments.SelectedItems.Count>0)&&(this.lvComments.SelectedItems[0].Index<this.lvComments.CheckedItems.Count-1))
			{
				try
				{
					int nextIndex = this.lvComments.SelectedItems[0].Index+1;
					DataRow commentBelow = (DataRow)this.lvComments.Items[nextIndex].Tag;
					DataRow comment = (DataRow)this.lvComments.Items[this.lvComments.SelectedItems[0].Index].Tag;
					
					if (!SetLocks(this.CategoryLockingGuid))
						return;

					short nextSortIndex = (short)commentBelow[CANNEDCOMMENT.SortColumn];
					commentBelow[CANNEDCOMMENT.SortColumn] = comment[CANNEDCOMMENT.SortColumn];
					commentBelow[CANNEDCOMMENT.LastUpdateUser] = ThisUser.UserNTLoginID;
					commentBelow[CANNEDCOMMENT.LastUpdateDate] = currentDate;
					comment[CANNEDCOMMENT.SortColumn] = nextSortIndex;
					comment[CANNEDCOMMENT.LastUpdateUser] = ThisUser.UserNTLoginID;
					comment[CANNEDCOMMENT.LastUpdateDate] = currentDate;
					this.RefreshListView();
					this.lvComments.Items[nextIndex].Selected = true;
					this.EnableOKButton();
				}
				catch(IndexOutOfRangeException)
				{
					//Nothing selected. Never mind.
				}
				catch(System.ArgumentOutOfRangeException)
				{
					return;
					//Nothing selected. Never mind.
				}
			}
			//
			this.lvComments.Focus();
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/6/2002</CreationDate>
		///
		/// <summary>
		/// Up button click event handler.
		/// Decrements sort index of selected item and increments sort index of item above.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnUp_Click(object sender, System.EventArgs e)
		{
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			if ((this.lvComments.SelectedItems.Count>0)&&(this.lvComments.SelectedItems[0].Index>0))
			{
				try
				{
					int previousIndex = this.lvComments.SelectedItems[0].Index-1;
					DataRow commentAbove = (DataRow)this.lvComments.Items[previousIndex].Tag;
					DataRow comment = (DataRow)this.lvComments.Items[this.lvComments.SelectedItems[0].Index].Tag;

					if (!SetLocks(this.CategoryLockingGuid))
						return;

					short previousSortIndex = (short)commentAbove[CANNEDCOMMENT.SortColumn];
					commentAbove[CANNEDCOMMENT.SortColumn] = comment[CANNEDCOMMENT.SortColumn];
					commentAbove[CANNEDCOMMENT.LastUpdateUser] = ThisUser.UserNTLoginID;
					commentAbove[CANNEDCOMMENT.LastUpdateDate] = currentDate;
					comment[CANNEDCOMMENT.SortColumn] = previousSortIndex;
					comment[CANNEDCOMMENT.LastUpdateUser] = ThisUser.UserNTLoginID;
					comment[CANNEDCOMMENT.LastUpdateDate] = currentDate;
					this.RefreshListView();
					this.lvComments.Items[previousIndex].Selected = true;
					this.EnableOKButton();
				}
				catch(IndexOutOfRangeException)
				{
					//Nothing selected. Never mind.
				}
				catch(System.ArgumentOutOfRangeException)
				{
					//Nothing selected. Never mind.
				}
			}
			//
			this.lvComments.Focus();
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/25/2002</CreationDate>
		///
		/// <summary>
		/// Save button mouse hover event handler. Displays broken rules as tool tip.
		/// </summary>
		/// <param name="sender">sender object</param>
		/// <param name="e">event args</param>
		private void btnSave_MouseHover(object sender, System.EventArgs e)
		{
			System.Text.StringBuilder str = new System.Text.StringBuilder();
			//
			str.Append(this._cannedComment.GetBrokenRulesMessage(this.Name));
			//
			if (str.ToString().Length == 0)
			{
				if (!_cannedComment.IsDirty)
				{
					btnSave.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
				}
				else
				{
					btnSave.SetToolTip(Common.StrRes.Tooltips.UC031.AddComment().ResString);
				}
			}
			else
			{
				btnSave.SetToolTip(str.ToString());
			}
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/25/2002</CreationDate>
		///
		/// <summary>
		/// OK button mouse hover event. Displays sets tool tip message
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnOK.EnabledButton)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			}
		}


        private void lvComments_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (!_refreshing)
            {
                if (_removeItem)
                {
                    ((ListView) sender).Items.Remove(e.Item);
                    _removeItem = false;
                }
                //CR 3316
                this.RefreshListView();
            }
        }
        #endregion

	}
}

